% Road_PSD
% Vytvari spektralni hustotu
%-------------------------------------------------------------------------
% Witten By Tomas Mauder, VUT v Brne, 2014.
%-------------------------------------------------------------------------

function [A omega phi psi] = Road_PSD(road,graphs)

% Koeficient drsnosti pro referencni vlnove cislo (wave number) 1 rad/m
phi0 = road.type;

% interval vlnoveho cisla pro PSD
omega0 = road.omega0;
omega1 = road.omega1;
omega2 = road.omega2;
omega_cut = road.omega_cut;

% pocet vln pro PSD
M = road.M;
% velikost kroku pro PSD
delta_omega = (omega2-omega1)/(M - 2);
% Rozsah vlnovych cisel
omega = linspace(omega1,omega2,M);
% Inicializace PSD
phi = zeros(1,M);
% Inicializace amplitud
A = zeros(1,M);

% Koeficient zvlneni (waviness);
% Dlouhe vlny
wL = road.wL;
% Kratke vlny
wS = road.wS;

% Vypocet PSD (eq. 2.16)
for i = 1:M  
        if omega(i) <= omega0
            phi(i) = phi0 * (omega(i)./omega0).^(-wL);
        else
            phi(i) = phi0 * (omega(i)./omega0).^(-wS);
        end              
end

for i = 1:M
        if omega(i) <= omega_cut
                phi(i) = phi0 * (omega(find(omega > omega_cut, 1 ))./omega0).^(-wL);
        end
end
% Vypocet amplitud (eq. 2.23)
A(1:M)= sqrt(2 * phi(1:M) * (delta_omega));


% Vygenerovani nahodnych uhlu
psi=random('unif',0,2*pi,M,1);

%-------------------------------------------------------------------------
% graficky vystup
if graphs == 1
phiA(1:M) = 1   * 10^-6 * (omega(1:M)./omega0).^(-2);
phiB(1:M) = 4   * 10^-6 * (omega(1:M)./omega0).^(-2);
phiC(1:M) = 16  * 10^-6 * (omega(1:M)./omega0).^(-2);
phiD(1:M) = 64  * 10^-6 * (omega(1:M)./omega0).^(-2);
phiE(1:M) = 256 * 10^-6 * (omega(1:M)./omega0).^(-2);


figure(1)
plot(omega,phi,'-b','linewidth',3);
title('PSD profil');
xlabel('Vlnove cislo [rad/m]');
ylabel('PSD [m^2/(rad/m)]');
set(gcf,'Color','w');

figure(2)
% x - vlnove cislo [rad/m], y - PSD [m^2/(rad/m)]
loglog(omega,phi,'-b','linewidth',3); hold on
loglog(omega,phiA,'-r');
loglog(omega,phiB,'-g');
loglog(omega,phiC,'-y');
loglog(omega,phiD,'-c');
loglog(omega,phiE,'-k'); hold off

title('log-log PSD profil');
xlabel('Vlnove cislo [rad/m]');
ylabel('PSD [m^2/(rad/m)]');
set(gcf,'Color','w');
legend('PSD','PSD_A','PSD_B','PSD_C','PSD_D','PSD_E')
end

